<?php
// admin/addshop.php
session_start();
require_once __DIR__ . '/../db.php';
if (!isset($_SESSION['admin_user'])) {
    header('Location: login.php');
    exit;
}

function sanitize_prefix($name){
    $p = strtolower($name);
    $p = preg_replace('/[^a-z0-9]/', '', $p);
    if ($p === '') $p = 'shop'.time();
    return $p;
}

$errors = [];
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $shop_name = trim($_POST['shop_name'] ?? '');
    $folder = trim($_POST['folder_name'] ?? '');
    $admin_username = trim($_POST['admin_username'] ?? '');
    $admin_password = trim($_POST['admin_password'] ?? '');

    if (!$shop_name) $errors[] = 'Shop name required';
    if ($folder === '') $folder = $shop_name;
    $prefix = sanitize_prefix($folder);

    // ensure unique prefix: add ii, iii etc if exists
    $original = $prefix;
    $i = 1;
    while (true) {
        // check folder and DB tables existence
        $products_table = $prefix . 'products';
        try {
            $res = $pdo->query("SHOW TABLES LIKE '".$products_table."'")->fetch();
        } catch (Exception $e) {
            $res = false;
        }
        if (!$res && !is_dir(__DIR__ . '/../shop/' . $prefix)) break;
        $i++;
        $suffix = str_repeat('i', $i); // ii, iii...
        $prefix = $original . $suffix;
        if ($i > 20) break;
    }

    $products_table = $prefix . 'products';
    $sales_table = $prefix . 'sales';
    $sale_items_table = $prefix . 'sale_items';

    // create tables
    try {
        $pdo->exec("CREATE TABLE IF NOT EXISTS `$products_table` (
            id INT AUTO_INCREMENT PRIMARY KEY,
            barcode VARCHAR(255) UNIQUE,
            category VARCHAR(150),
            name VARCHAR(255),
            buy_price DECIMAL(10,2),
            min_price DECIMAL(10,2),
            mrp DECIMAL(10,2),
            stock INT DEFAULT 1,
            status VARCHAR(50) DEFAULT 'available',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

        $pdo->exec("CREATE TABLE IF NOT EXISTS `$sales_table` (
            id INT AUTO_INCREMENT PRIMARY KEY,
            customer_name VARCHAR(255),
            customer_email VARCHAR(255),
            customer_phone VARCHAR(50),
            customer_address TEXT,
            date DATETIME DEFAULT CURRENT_TIMESTAMP,
            subtotal DECIMAL(12,2),
            discount DECIMAL(12,2) DEFAULT 0,
            discount_type ENUM('percent','fixed') DEFAULT 'percent',
            vat DECIMAL(12,2) DEFAULT 0,
            grand_total DECIMAL(12,2),
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

        $pdo->exec("CREATE TABLE IF NOT EXISTS `$sale_items_table` (
            id INT AUTO_INCREMENT PRIMARY KEY,
            sale_id INT,
            product_id INT,
            barcode VARCHAR(255),
            name VARCHAR(255),
            qty INT,
            price DECIMAL(12,2),
            total DECIMAL(12,2),
            FOREIGN KEY (sale_id) REFERENCES `$sales_table`(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

    } catch (PDOException $e) {
        $errors[] = 'DB error: ' . $e->getMessage();
    }

    // ensure users table exists and insert shop admin
    try {
        $pdo->exec("CREATE TABLE IF NOT EXISTS `users` (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(100) UNIQUE,
            password VARCHAR(255),
            role VARCHAR(50),
            shop_prefix VARCHAR(100),
            created_at DATETIME DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");

        if ($admin_username === '') $admin_username = $prefix . '_admin';
        if ($admin_password === '') $admin_password = '1234';

        $check = $pdo->prepare("SELECT id FROM users WHERE username = ? LIMIT 1");
        $check->execute([$admin_username]);
        if (!$check->fetch()) {
            $ins = $pdo->prepare("INSERT INTO users (username, password, role, shop_prefix) VALUES (?, ?, 'admin', ?)");
            $ins->execute([$admin_username, $admin_password, $prefix]);
        } else {
            // update shop_prefix if needed
            $upd = $pdo->prepare("UPDATE users SET shop_prefix = ? WHERE username = ?");
            $upd->execute([$prefix, $admin_username]);
        }
    } catch (PDOException $e) {
        $errors[] = 'User table error: ' . $e->getMessage();
    }

    // copy template to shop/<prefix>
    $templateDir = __DIR__ . '/../shop_template';
    $targetBase = __DIR__ . '/../shop';
    $targetDir = $targetBase . '/' . $prefix;
    if (!is_dir($templateDir)) {
        $errors[] = 'Template folder missing: shop_template';
    } else {
        if (is_dir($targetDir)) {
            $errors[] = 'Target folder already exists: ' . $targetDir;
        } else {
            // recursive copy
            $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($templateDir, RecursiveDirectoryIterator::SKIP_DOTS), RecursiveIteratorIterator::SELF_FIRST);
            foreach ($it as $item) {
                $dest = $targetDir . DIRECTORY_SEPARATOR . $it->getSubPathName();
                if ($item->isDir()) {
                    mkdir($dest, 0755, true);
                } else {
                    copy($item->getPathname(), $dest);
                }
            }
            // write config.php
            $config = "<?php\n// Auto-generated config\n\$shop_prefix = '" . $prefix . "';\nrequire_once __DIR__ . '/../../db.php';\n";
            file_put_contents($targetDir . '/config.php', $config);
        }
    }

    if (empty($errors)) {
        $success = "Shop created successfully!\nPrefix: $prefix\nURL: /shop/$prefix/\nAdmin: $admin_username (password: $admin_password)";
    }
}

?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Add Shop</title></head>
<body>
<h2>Add Shop (Admin)</h2>
<p><a href="logout.php">Logout</a></p>
<?php if($errors): ?><div style="color:red;"><strong>Errors:</strong><br><?php echo implode('<br>', $errors); ?></div><?php endif; ?>
<?php if($success): ?><div style="color:green; white-space:pre-wrap;"><?php echo htmlspecialchars($success); ?></div><?php endif; ?>

<form method="post">
  <label>Shop display name (ex: Mahin Telicom):</label><br>
  <input type="text" name="shop_name" required><br>
  <label>Folder name (optional, latin letters):</label><br>
  <input type="text" name="folder_name" placeholder="leave empty to generate from name"><br>
  <label>Shop admin username (optional):</label><br>
  <input type="text" name="admin_username" placeholder="leave empty -> prefix_admin"><br>
  <label>Shop admin password (optional):</label><br>
  <input type="text" name="admin_password" placeholder="leave empty -> 1234"><br><br>
  <button type="submit">Create Shop</button>
</form>

</body></html>
